---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：26-Master Log（マスターログ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **JavaScript関数の動作詳細**：utils.jsの直接読み込みは行っていないため推定

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/master/ui/LogPage.scala`（79行）
- E-02: `core/src/main/scala/org/apache/spark/deploy/Utils.scala`（105行）
- E-03: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala`（135行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/logPage/?self&logType={logType}` | E-01 (28行目: `WebUIPage("logPage")`), (58行目: `logParams`) | ○ |
| C-02 | ログディレクトリはSPARK_LOG_DIR環境変数（デフォルト"logs/"） | E-01 (30行目), E-02 (46行目) | ○ |
| C-03 | サポートログタイプはstderr, stdout, out | E-02 (37行目: `SUPPORTED_LOG_TYPES`) | ○ |
| C-04 | デフォルト表示バイト数は100KB | E-02 (36行目: `DEFAULT_BYTES = 100 * 1024`) | ○ |
| C-05 | deploy.Utils.getLogでログファイルを読み取り | E-01 (35-36行目), E-02 (58-103行目) | ○ |
| C-06 | Load More/Load Newボタンが存在 | E-01 (43-51行目) | ○ |
| C-07 | End of Logアラートが存在 | E-01 (53-56行目) | ○ |
| C-08 | initLogPage JavaScript関数が初期化される | E-01 (59-60行目) | ○ |
| C-09 | Back to Masterリンクが存在 | E-01 (66行目: `<a href="/">Back to Master</a>`) | ○ |
| C-10 | ログ表示領域はheight:80vh | E-01 (67行目) | ○ |
| C-11 | ページタイトルは"{logType} log page for master" | E-01 (76行目) | ○ |
| C-12 | テキストAPIは/logエンドポイント | E-02 (39-43行目: `addRenderLogHandler`), E-03 (65行目) | ○ |
| C-13 | RollingFileAppender対応 | E-02 (77行目: `RollingFileAppender.getSortedRolledOverFiles`) | ○ |
| C-14 | offsetが未指定の場合は末尾からbyteLength分を表示 | E-02 (82行目: `val offset = offsetOption.getOrElse(totalLength - byteLength)`) | ○ |
| C-15 | loadMore/loadNew JavaScript関数の動作詳細 | **根拠なし**（utils.jsの直接読み込み未実施） | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: loadMore/loadNewのAJAX呼び出し先・動作詳細はutils.jsの確認が必要
  - 候補：core/src/main/resources/org/apache/spark/ui/static/utils.js

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドの処理は全て根拠あり。クライアントサイドJavaScriptの詳細のみ未確認

## 6) レビュアーチェックリスト（最小）
- [ ] utils.jsのloadMore/loadNew関数の動作が設計書の記述と一致するか確認
- [ ] ログファイルのパスに対するセキュリティ（パストラバーサル防止）が考慮されているか確認
